using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;

using Huezo.CombineBitmap;

namespace CombineBitmapExample
{
	/// <summary>
	/// Zusammenfassung fr frmMain.
	/// </summary>
	public class frmMain : System.Windows.Forms.Form
	{
		private System.Windows.Forms.PictureBox pict1;
		private System.Windows.Forms.PictureBox pict2;
		private System.Windows.Forms.Label lblPict1;
		private System.Windows.Forms.Label lblPict2;
		private System.Windows.Forms.LinkLabel lnkPict1;
		private System.Windows.Forms.GroupBox grpDirection;
		private System.Windows.Forms.RadioButton radVertical;
		private System.Windows.Forms.RadioButton radHorizontal;
		private System.Windows.Forms.GroupBox grpBackground;
		private System.Windows.Forms.RadioButton radTransparent;
		private System.Windows.Forms.RadioButton radColor;
		private System.Windows.Forms.LinkLabel lnkPict2;
		private System.Windows.Forms.LinkLabel lnkCombineBitmaps;
		private System.Windows.Forms.ColorDialog colorDialog;
		private System.Windows.Forms.OpenFileDialog fileDialog;
		private System.Windows.Forms.LinkLabel lnkColor;
		private System.Windows.Forms.PictureBox pictCombined;
		private System.Windows.Forms.GroupBox grpIterations;
		private System.Windows.Forms.NumericUpDown nudIterations;
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmMain()
		{
			//
			// Erforderlich fr die Windows Form-Designeruntersttzung
			//
			InitializeComponent();

			//
			// TODO: Fgen Sie den Konstruktorcode nach dem Aufruf von InitializeComponent hinzu
			//
			lblPict1.Text = string.Empty;
			lblPict2.Text = string.Empty;

			colorDialog.Color = radColor.BackColor = this.BackColor;
			fileDialog.InitialDirectory = Directory.GetCurrentDirectory();

			SetView();

		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.pict1 = new System.Windows.Forms.PictureBox();
			this.pict2 = new System.Windows.Forms.PictureBox();
			this.lblPict1 = new System.Windows.Forms.Label();
			this.lblPict2 = new System.Windows.Forms.Label();
			this.lnkPict1 = new System.Windows.Forms.LinkLabel();
			this.lnkPict2 = new System.Windows.Forms.LinkLabel();
			this.grpDirection = new System.Windows.Forms.GroupBox();
			this.radHorizontal = new System.Windows.Forms.RadioButton();
			this.radVertical = new System.Windows.Forms.RadioButton();
			this.grpBackground = new System.Windows.Forms.GroupBox();
			this.radColor = new System.Windows.Forms.RadioButton();
			this.radTransparent = new System.Windows.Forms.RadioButton();
			this.lnkColor = new System.Windows.Forms.LinkLabel();
			this.lnkCombineBitmaps = new System.Windows.Forms.LinkLabel();
			this.colorDialog = new System.Windows.Forms.ColorDialog();
			this.fileDialog = new System.Windows.Forms.OpenFileDialog();
			this.pictCombined = new System.Windows.Forms.PictureBox();
			this.grpIterations = new System.Windows.Forms.GroupBox();
			this.nudIterations = new System.Windows.Forms.NumericUpDown();
			this.grpDirection.SuspendLayout();
			this.grpBackground.SuspendLayout();
			this.grpIterations.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.nudIterations)).BeginInit();
			this.SuspendLayout();
			// 
			// pict1
			// 
			this.pict1.Location = new System.Drawing.Point(16, 8);
			this.pict1.Name = "pict1";
			this.pict1.Size = new System.Drawing.Size(96, 104);
			this.pict1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pict1.TabIndex = 0;
			this.pict1.TabStop = false;
			// 
			// pict2
			// 
			this.pict2.Location = new System.Drawing.Point(16, 184);
			this.pict2.Name = "pict2";
			this.pict2.Size = new System.Drawing.Size(96, 104);
			this.pict2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pict2.TabIndex = 1;
			this.pict2.TabStop = false;
			// 
			// lblPict1
			// 
			this.lblPict1.AutoSize = true;
			this.lblPict1.Location = new System.Drawing.Point(16, 120);
			this.lblPict1.Name = "lblPict1";
			this.lblPict1.Size = new System.Drawing.Size(48, 17);
			this.lblPict1.TabIndex = 2;
			this.lblPict1.Text = "Picture 1";
			// 
			// lblPict2
			// 
			this.lblPict2.AutoSize = true;
			this.lblPict2.Location = new System.Drawing.Point(18, 296);
			this.lblPict2.Name = "lblPict2";
			this.lblPict2.Size = new System.Drawing.Size(48, 17);
			this.lblPict2.TabIndex = 3;
			this.lblPict2.Text = "Picture 2";
			// 
			// lnkPict1
			// 
			this.lnkPict1.AutoSize = true;
			this.lnkPict1.LinkBehavior = System.Windows.Forms.LinkBehavior.HoverUnderline;
			this.lnkPict1.Location = new System.Drawing.Point(16, 144);
			this.lnkPict1.Name = "lnkPict1";
			this.lnkPict1.Size = new System.Drawing.Size(81, 17);
			this.lnkPict1.TabIndex = 4;
			this.lnkPict1.TabStop = true;
			this.lnkPict1.Text = "Select Picture 1";
			this.lnkPict1.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.lnk_LinkClicked);
			// 
			// lnkPict2
			// 
			this.lnkPict2.AutoSize = true;
			this.lnkPict2.LinkBehavior = System.Windows.Forms.LinkBehavior.HoverUnderline;
			this.lnkPict2.Location = new System.Drawing.Point(16, 320);
			this.lnkPict2.Name = "lnkPict2";
			this.lnkPict2.Size = new System.Drawing.Size(81, 17);
			this.lnkPict2.TabIndex = 5;
			this.lnkPict2.TabStop = true;
			this.lnkPict2.Text = "Select Picture 2";
			this.lnkPict2.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.lnk_LinkClicked);
			// 
			// grpDirection
			// 
			this.grpDirection.Controls.Add(this.radHorizontal);
			this.grpDirection.Controls.Add(this.radVertical);
			this.grpDirection.Location = new System.Drawing.Point(120, 10);
			this.grpDirection.Name = "grpDirection";
			this.grpDirection.Size = new System.Drawing.Size(120, 88);
			this.grpDirection.TabIndex = 6;
			this.grpDirection.TabStop = false;
			this.grpDirection.Text = "Direction";
			// 
			// radHorizontal
			// 
			this.radHorizontal.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.radHorizontal.Location = new System.Drawing.Point(8, 48);
			this.radHorizontal.Name = "radHorizontal";
			this.radHorizontal.TabIndex = 1;
			this.radHorizontal.Text = "Horizontal";
			// 
			// radVertical
			// 
			this.radVertical.Checked = true;
			this.radVertical.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.radVertical.Location = new System.Drawing.Point(8, 16);
			this.radVertical.Name = "radVertical";
			this.radVertical.TabIndex = 0;
			this.radVertical.TabStop = true;
			this.radVertical.Text = "Vertical";
			// 
			// grpBackground
			// 
			this.grpBackground.Controls.Add(this.radColor);
			this.grpBackground.Controls.Add(this.radTransparent);
			this.grpBackground.Controls.Add(this.lnkColor);
			this.grpBackground.Location = new System.Drawing.Point(120, 106);
			this.grpBackground.Name = "grpBackground";
			this.grpBackground.Size = new System.Drawing.Size(120, 96);
			this.grpBackground.TabIndex = 7;
			this.grpBackground.TabStop = false;
			this.grpBackground.Text = "Background";
			// 
			// radColor
			// 
			this.radColor.Checked = true;
			this.radColor.Enabled = false;
			this.radColor.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.radColor.Location = new System.Drawing.Point(8, 40);
			this.radColor.Name = "radColor";
			this.radColor.TabIndex = 7;
			this.radColor.TabStop = true;
			this.radColor.Text = "Color";
			// 
			// radTransparent
			// 
			this.radTransparent.Enabled = false;
			this.radTransparent.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.radTransparent.Location = new System.Drawing.Point(8, 16);
			this.radTransparent.Name = "radTransparent";
			this.radTransparent.TabIndex = 6;
			this.radTransparent.Text = "Transparent";
			// 
			// lnkColor
			// 
			this.lnkColor.AutoSize = true;
			this.lnkColor.Enabled = false;
			this.lnkColor.LinkBehavior = System.Windows.Forms.LinkBehavior.HoverUnderline;
			this.lnkColor.Location = new System.Drawing.Point(15, 72);
			this.lnkColor.Name = "lnkColor";
			this.lnkColor.Size = new System.Drawing.Size(63, 17);
			this.lnkColor.TabIndex = 5;
			this.lnkColor.TabStop = true;
			this.lnkColor.Text = "Select Color";
			this.lnkColor.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.lnk_LinkClicked);
			// 
			// lnkCombineBitmaps
			// 
			this.lnkCombineBitmaps.AutoSize = true;
			this.lnkCombineBitmaps.LinkBehavior = System.Windows.Forms.LinkBehavior.HoverUnderline;
			this.lnkCombineBitmaps.Location = new System.Drawing.Point(126, 316);
			this.lnkCombineBitmaps.Name = "lnkCombineBitmaps";
			this.lnkCombineBitmaps.Size = new System.Drawing.Size(91, 17);
			this.lnkCombineBitmaps.TabIndex = 8;
			this.lnkCombineBitmaps.TabStop = true;
			this.lnkCombineBitmaps.Text = "Combine Bitmaps";
			this.lnkCombineBitmaps.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.lnk_LinkClicked);
			// 
			// colorDialog
			// 
			this.colorDialog.AnyColor = true;
			this.colorDialog.FullOpen = true;
			// 
			// pictCombined
			// 
			this.pictCombined.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pictCombined.Location = new System.Drawing.Point(246, 8);
			this.pictCombined.Name = "pictCombined";
			this.pictCombined.Size = new System.Drawing.Size(292, 328);
			this.pictCombined.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictCombined.TabIndex = 9;
			this.pictCombined.TabStop = false;
			// 
			// grpIterations
			// 
			this.grpIterations.Controls.Add(this.nudIterations);
			this.grpIterations.Location = new System.Drawing.Point(122, 208);
			this.grpIterations.Name = "grpIterations";
			this.grpIterations.Size = new System.Drawing.Size(120, 96);
			this.grpIterations.TabIndex = 10;
			this.grpIterations.TabStop = false;
			this.grpIterations.Text = "Iterations";
			// 
			// nudIterations
			// 
			this.nudIterations.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.nudIterations.Location = new System.Drawing.Point(12, 34);
			this.nudIterations.Maximum = new System.Decimal(new int[] {
																		  5,
																		  0,
																		  0,
																		  0});
			this.nudIterations.Minimum = new System.Decimal(new int[] {
																		  1,
																		  0,
																		  0,
																		  0});
			this.nudIterations.Name = "nudIterations";
			this.nudIterations.Size = new System.Drawing.Size(90, 21);
			this.nudIterations.TabIndex = 0;
			this.nudIterations.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.nudIterations.Value = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
			this.ClientSize = new System.Drawing.Size(544, 342);
			this.Controls.Add(this.grpIterations);
			this.Controls.Add(this.pictCombined);
			this.Controls.Add(this.lnkCombineBitmaps);
			this.Controls.Add(this.grpBackground);
			this.Controls.Add(this.grpDirection);
			this.Controls.Add(this.lnkPict2);
			this.Controls.Add(this.lnkPict1);
			this.Controls.Add(this.lblPict2);
			this.Controls.Add(this.lblPict1);
			this.Controls.Add(this.pict2);
			this.Controls.Add(this.pict1);
			this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.MinimumSize = new System.Drawing.Size(552, 368);
			this.Name = "frmMain";
			this.Text = "CombineBitmap Example";
			this.grpDirection.ResumeLayout(false);
			this.grpBackground.ResumeLayout(false);
			this.grpIterations.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.nudIterations)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new frmMain());
		}


		#region CombineBitmap Code
		private void lnk_LinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			LinkLabel lnk = sender as LinkLabel;
			if(lnk!=null)
			{
				if(lnk==lnkPict1||lnk==lnkPict2)
				{
					if(DialogResult.OK==fileDialog.ShowDialog(this))
					{
						string filename = fileDialog.FileName;
						SetPicture(
							filename,
							(lnk==lnkPict1?pict1:pict2),
							(lnk==lnkPict1?lblPict1:lblPict2));
					}	
				}
				else if(lnk==lnkColor)
				{
					if(DialogResult.OK==colorDialog.ShowDialog(this))
						radColor.BackColor = colorDialog.Color;
				}
				else if(lnk==lnkCombineBitmaps)
				{
					CombineBitmaps();
				}
	
				SetView();
			}	
		}
		
		private void SetView()
		{
			bool bpict1 = (lblPict1.Text.Length>0);
			bool bpict2 = (lblPict2.Text.Length>0);

			lnkCombineBitmaps.Enabled = (bpict1&&bpict2);

		}

		private void SetPicture(string filename, PictureBox pict, Label lbl)
		{
			if((filename!=null&&filename.Length>0&&File.Exists(filename))&&
				pict!=null&&
				lbl!=null)
			{
				Bitmap bmp = new Bitmap(filename);
				if(bmp!=null)
				{
					pict.Image = bmp;
					lbl.Text = Path.GetFileName(filename);
				}
			}
		}

		private void CombineBitmaps()
		{
			try
			{
				Cursor.Current = Cursors.WaitCursor;

				CombineBitmap	cb		= new CombineBitmap();
				cbDirection		cbD		= cbDirection.Vertical;
				Color			bgcolor = radColor.BackColor;
				Bitmap			bmp1	= (Bitmap) pict1.Image;
				Bitmap			bmp2	= (Bitmap) pict2.Image;
				int				iter	= (int) nudIterations.Value;

				if(bmp1!=null&&bmp2!=null)
				{
					if(radHorizontal.Checked==true)
						cbD = cbDirection.Horizontal;

					Bitmap cmbmp = bmp1;
					Bitmap bmp = null;

					for(int i = 0; i < iter; i++)
					{
						if(i%2==0)
							bmp = bmp2;
						else
							bmp = bmp1;

						cmbmp = cb.CombineBitmaps(
							cmbmp,
							bmp,
							cbD,
							bgcolor);
					}
					if(cmbmp!=null)
						pictCombined.Image = cmbmp;
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show(this, 
					String.Format("Error by CombineBitmaps (StackTrace):\n{0}", ex.StackTrace), 
					"Error",
					MessageBoxButtons.OK,
					MessageBoxIcon.Error);
			}
			finally
			{
				Cursor.Current = Cursors.Default;
			}
		}
		#endregion
	}
}
